CREATE DATABASE IF NOT EXISTS polideportivos;
USE polideportivos;

CREATE TABLE IF NOT EXISTS polideportivos
(
	id INT UNSIGNED PRIMARY KEY AUTO_INCREMENT,
	nombre VARCHAR(50) UNIQUE NOT NULL,
	direccion VARCHAR(50) NOT NULL,
	extension INT UNSIGNED DEFAULT 0
);
CREATE TABLE IF NOT EXISTS pistas
(
	id INT UNSIGNED PRIMARY KEY AUTO_INCREMENT,
	codigo VARCHAR(10) NOT NULL,
	tipo VARCHAR(20),
	operativa BOOLEAN DEFAULT TRUE,
	precio FLOAT DEFAULT 0,
	fecha_ultima_reserva DATETIME,
	id_polideportivo INT UNSIGNED NOT NULL 
		REFERENCES polideportivos
);
CREATE TABLE IF NOT EXISTS reservas
(
	id INT UNSIGNED PRIMARY KEY AUTO_INCREMENT,
	fecha_reserva DATE DEFAULT CURRENT_TIMESTAMP(),
	fecha_uso DATETIME NOT NULL,
	precio FLOAT DEFAULT 0,
	id_pista INT UNSIGNED NOT NULL REFERENCES pistas
);
CREATE TABLE IF NOT EXISTS usuarios
(
	id INT UNSIGNED PRIMARY KEY AUTO_INCREMENT,
	nombre VARCHAR(50) NOT NULL,
	apellidos VARCHAR(50) NOT NULL,
	email VARCHAR(50) NOT NULL UNIQUE,
	telefono VARCHAR(12),
	dni VARCHAR(10) UNIQUE NOT NULL,
	fecha_nacimiento DATE NOT NULL
);
CREATE TABLE IF NOT EXISTS usuario_reserva
(
	id_usuario INT UNSIGNED REFERENCES usuarios,
	id_reserva INT UNSIGNED REFERENCES reservas,
	PRIMARY KEY (id_usuario, id_reserva)
);




